using DicomObjects;
using DicomObjects.Enums;
using DicomObjects.EventArguments;
using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Data.SQLite;
using System.Linq;
using System.Windows.Forms;

namespace SCP
{
    public class Form1 : Form
    {
        private const string ConnectionString = @"Data Source=""..\..\MWL_Database.db"";Version=3;";
        private const string InvalidQuery = "Invalid Query Root : None";
        private const string SelectAllExamsScheduled = "select * from examsscheduled";
        private const string SelectAllExamsScheduledWithWhere = "SELECT * from ExamsScheduled Where 1=1";
        private const string OrderBy = " Order by Surname, Forename";
        private const string QueryStatement = "SQL query statement:";
        private const string PatientId = "PatientID";
        private const string Surname = "surname";
        private const string Forname = "Forename";
        private const string ScheduledAET = "ScheduledAET";
        private const string PerformingPhysician = "PerformingPhysician";
        private const string Modality = "Modality";
        private const string ExamDateAndTime = "ExamDateAndTime";
        private const string ExamRoom = "ExamRoom";
        private const string ExamDescription = "ExamDescription";
        private const string SendingResponse = "Sending response ..";
        private const string ErrorExecutingDatabase = "Error executing Database -- ";
        private const string DatabaseDisconnected = "Database Disconnected Normally";
        private const string AssociationRequestFrom = "Association Request from ";
        private const string At = " At ";

        internal static class StatusCodes
        {
            public const int Success = 0x0;
            public const int GeneralError = 0xC000;
            public const int Pending = 0xFF00;
            public const int InvalidQueryRoot = 0xC001;

        }

#region "Variables"
        internal TextBox TextBox1;
        internal TextBox TextBox2;
        internal CheckBox DisableDateMatching;
        internal TextBox Report;
        internal TextBox Logger;

        private readonly System.ComponentModel.Container components = null;

        private DicomServer MWL_Server;
        private CheckBox ReportEnabled;
        private CheckBox LogEnabled;
        private RadioButton LINQMode;
        
        #endregion 

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing && components != null)
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this.TextBox1 = new System.Windows.Forms.TextBox();
            this.TextBox2 = new System.Windows.Forms.TextBox();
            this.DisableDateMatching = new System.Windows.Forms.CheckBox();
            this.Report = new System.Windows.Forms.TextBox();
            this.Logger = new System.Windows.Forms.TextBox();
            this.ReportEnabled = new System.Windows.Forms.CheckBox();
            this.LogEnabled = new System.Windows.Forms.CheckBox();
            RadioButton SQLMode = new System.Windows.Forms.RadioButton();
            this.LINQMode = new System.Windows.Forms.RadioButton();
            GroupBox groupBox1 = new System.Windows.Forms.GroupBox();
            groupBox1.SuspendLayout();
            this.SuspendLayout();
            // 
            // TextBox1
            // 
            this.TextBox1.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.TextBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.TextBox1.Location = new System.Drawing.Point(12, 16);
            this.TextBox1.Multiline = true;
            this.TextBox1.Name = "TextBox1";
            this.TextBox1.ReadOnly = true;
            this.TextBox1.Size = new System.Drawing.Size(479, 257);
            this.TextBox1.TabIndex = 9;
            this.TextBox1.Text = resources.GetString("TextBox1.Text");
            // 
            // TextBox2
            // 
            this.TextBox2.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.TextBox2.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.TextBox2.Location = new System.Drawing.Point(12, 279);
            this.TextBox2.Multiline = true;
            this.TextBox2.Name = "TextBox2";
            this.TextBox2.ReadOnly = true;
            this.TextBox2.Size = new System.Drawing.Size(475, 40);
            this.TextBox2.TabIndex = 9;
            this.TextBox2.Text = "For early testing/development, you may wish to disable the \"date\" matching, to sa" +
    "ve having to update your database every day";
            // 
            // DisableDateMatching
            // 
            this.DisableDateMatching.Checked = true;
            this.DisableDateMatching.CheckState = System.Windows.Forms.CheckState.Checked;
            this.DisableDateMatching.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.DisableDateMatching.Location = new System.Drawing.Point(12, 325);
            this.DisableDateMatching.Name = "DisableDateMatching";
            this.DisableDateMatching.Size = new System.Drawing.Size(170, 27);
            this.DisableDateMatching.TabIndex = 8;
            this.DisableDateMatching.Text = "Disable Date Matching";
            // 
            // Report
            // 
            this.Report.BackColor = System.Drawing.SystemColors.HighlightText;
            this.Report.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.Report.Location = new System.Drawing.Point(12, 358);
            this.Report.Multiline = true;
            this.Report.Name = "Report";
            this.Report.ReadOnly = true;
            this.Report.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.Report.Size = new System.Drawing.Size(475, 159);
            this.Report.TabIndex = 9;
            // 
            // Logger
            // 
            this.Logger.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.Logger.Location = new System.Drawing.Point(497, 24);
            this.Logger.Multiline = true;
            this.Logger.Name = "Logger";
            this.Logger.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.Logger.Size = new System.Drawing.Size(392, 535);
            this.Logger.TabIndex = 10;
            // 
            // ReportEnabled
            // 
            this.ReportEnabled.AutoSize = true;
            this.ReportEnabled.Checked = true;
            this.ReportEnabled.CheckState = System.Windows.Forms.CheckState.Checked;
            this.ReportEnabled.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.ReportEnabled.Location = new System.Drawing.Point(188, 331);
            this.ReportEnabled.Name = "ReportEnabled";
            this.ReportEnabled.Size = new System.Drawing.Size(148, 21);
            this.ReportEnabled.TabIndex = 12;
            this.ReportEnabled.Text = "Enable Live Report";
            this.ReportEnabled.UseVisualStyleBackColor = true;
            // 
            // LogEnabled
            // 
            this.LogEnabled.AutoSize = true;
            this.LogEnabled.Location = new System.Drawing.Point(498, 5);
            this.LogEnabled.Name = "LogEnabled";
            this.LogEnabled.Size = new System.Drawing.Size(172, 17);
            this.LogEnabled.TabIndex = 13;
            this.LogEnabled.Text = "Enable Live DicomObjects Log";
            this.LogEnabled.UseVisualStyleBackColor = true;
            // 
            // SQLMode
            // 
            SQLMode.AutoSize = true;
            SQLMode.Checked = true;
            SQLMode.Location = new System.Drawing.Point(15, 18);
            SQLMode.Name = "SQLMode";
            SQLMode.Size = new System.Drawing.Size(46, 17);
            SQLMode.TabIndex = 14;
            SQLMode.TabStop = true;
            SQLMode.Text = "SQL";
            SQLMode.UseVisualStyleBackColor = true;
            // 
            // LINQMode
            // 
            this.LINQMode.AutoSize = true;
            this.LINQMode.Location = new System.Drawing.Point(84, 18);
            this.LINQMode.Name = "LINQMode";
            this.LINQMode.Size = new System.Drawing.Size(50, 17);
            this.LINQMode.TabIndex = 15;
            this.LINQMode.Text = "LINQ";
            this.LINQMode.UseVisualStyleBackColor = true;
            // 
            // groupBox1
            // 
            groupBox1.Controls.Add(this.LINQMode);
            groupBox1.Controls.Add(SQLMode);
            groupBox1.Location = new System.Drawing.Point(157, 523);
            groupBox1.Name = "groupBox1";
            groupBox1.Size = new System.Drawing.Size(142, 44);
            groupBox1.TabIndex = 16;
            groupBox1.TabStop = false;
            groupBox1.Text = "Database query mode";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(901, 571);
            this.Controls.Add(this.LogEnabled);
            this.Controls.Add(this.ReportEnabled);
            this.Controls.Add(this.Logger);
            this.Controls.Add(this.Report);
            this.Controls.Add(this.DisableDateMatching);
            this.Controls.Add(this.TextBox2);
            this.Controls.Add(this.TextBox1);
            this.Controls.Add(groupBox1);
            this.Name = "Form1";
            this.Text = "MWL SCP example";
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
            this.Load += new System.EventHandler(this.Form1_Load);
            groupBox1.ResumeLayout(false);
            groupBox1.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.Run(new Form1());
        }

#region  "Startup"
        private void Form1_Load(object sender, EventArgs e)
        {
            MWL_Server = new DicomServer();
            MWL_Server.VerifyReceived += MWL_Server_VerifyReceived;
            MWL_Server.AssociationRequest += MWL_Server_AssociationRequest;
            MWL_Server.QueryReceived += MWL_Server_QueryReceived;
            MWL_Server.Listen(104);

            //Put the following line back in to enable DicomObjects logging
            //DicomObjects.DicomGlobal.LogToFile("c:\\dicom log files", 0x63);

            DicomGlobal.EventLogLevel = (LogLevel)0x3F;
            DicomGlobal.LogEvent += DicomGlobal_LogEvent;
        }
        #endregion

        #region "Logging"
        private void DicomGlobal_LogEvent(DicomObjects.EventArguments.LogEventArgs e)
        {
            if (LogEnabled.Checked)
            {
                AppendText(Logger, e.Text);
            }
        }

        private void Log(string s)
        {
            if (ReportEnabled.Checked)
            {
                AppendText(Report, s);
            }
        }

        delegate void SetTextCallback(TextBox box, string text);

        private void AppendText(TextBox box, string text)
        {
            if (box.InvokeRequired)
            {
                SetTextCallback d = AppendText;
                Invoke(d, new object[] { box, text });
            }
            else
            {
                box.AppendText(text + "\r\n");
            }
        }
        #endregion

        #region "DICOM Event Handlers"
        private void MWL_Server_AssociationRequest(object sender, AssociationRequestArgs e)
        {
            Log(AssociationRequestFrom + e.Association.CallingAET + At + e.Association.RemoteIP);
            // Reject any irrelevant Contexts			
            foreach (DicomContext context in e.Contexts)
            {
                if (context.AbstractSyntax != DicomObjects.DicomUIDs.SOPClasses.ModalityWorklistQRFIND
                    && context.AbstractSyntax != DicomObjects.DicomUIDs.SOPClasses.Verification)
                {
                    context.Reject(3); // 3- Abstract Syntax Not Supported
                }
            }
        }

        private void MWL_Server_VerifyReceived(object sender, VerifyReceivedArgs e)
        {
            e.Status = 0;
        }


        private void MWL_Server_QueryReceived(object sender, QueryReceivedArgs e)
        {
            DicomDataSetCollection NullSequence = new DicomDataSetCollection();
            DicomDataSet rq;
            DicomDataSet rq1 = null;
            IEnumerable<ExamsScheduled> results = new List<ExamsScheduled>();
            int status = 0;
            try
            {
                using (SQLiteConnection db = new SQLiteConnection(ConnectionString))
                {
                    db.Open();
                    using (var DBContext = new DataContext(db))
                    {
                        if (e.Root != QueryRoot.ModalityWorklist)
                        {
                            e.Errors.Add(Keyword.ErrorComment, InvalidQuery);
                            e.Status = StatusCodes.InvalidQueryRoot;
                            return;
                        }
                        // Get the Imcoming Query Request
                        rq = e.RequestAssociation.Request;

                        // In a "Real" MWl server, this would either itself be a complex linked query, or a reference to such
                        // a query as a "view" or similar in the underlying database

                        //  Switching DB connection mode
                        if (LINQMode.Checked)
                        {
                            // Using LINQ to DB
                            IQueryable<ExamsScheduled> exams = DBContext.ExecuteQuery<ExamsScheduled>(SelectAllExamsScheduled).AsQueryable();
                            if (rq[Keyword.PatientID].ExistsWithValue)
                                exams = exams.Where(x => x.PatientID.Equals(rq[Keyword.PatientID].Value.ToString()));

                            if (rq[Keyword.PatientName].ExistsWithValue)
                                exams = Utils_LINQ.AddNameCondition(exams, rq[Keyword.PatientName]);


                            if (rq[Keyword.ScheduledProcedureStepSequence].ExistsWithValue)
                            {
                                DicomDataSetCollection rqs;

                                rqs = (DicomDataSetCollection)rq[Keyword.ScheduledProcedureStepSequence].Value;
                                rq1 = rqs[0];

                                // Required Matching keys
                                if (rq1[Keyword.ScheduledStationAETitle].ExistsWithValue)
                                    exams = exams.Where(x => x.ScheduledAET.Equals(rq1[Keyword.ScheduledStationAETitle].Value.ToString()));

                                if (rq1[Keyword.PerformingPhysicianName].ExistsWithValue)
                                    exams = exams.Where(x => x.PerformingPhysician.Equals(rq1[Keyword.PerformingPhysicianName].Value.ToString()));

                                if (rq1[Keyword.Modality].ExistsWithValue)
                                    exams = exams.Where(x => x.Modality.Equals(rq1[Keyword.Modality].Value.ToString()));

                                // if only date is specified, then using standard matching
                                //but if both are specified, then MWL defines a combined match

                                if (!DisableDateMatching.Checked)
                                {
                                    if (rq1[Keyword.ScheduledProcedureStepStartDate].ExistsWithValue && rq1[Keyword.ScheduledProcedureStepStartTime].ExistsWithValue) // if both Date and Time are specified
                                    {
                                        exams = Utils_LINQ.AddDateTimeCondition(exams, rq1[Keyword.ScheduledProcedureStepStartDate], rq1[Keyword.ScheduledProcedureStepStartTime]);
                                    }
                                    else if (rq1[Keyword.ScheduledProcedureStepStartDate].ExistsWithValue) // if Date is specified
                                    {
                                        exams = Utils_LINQ.AddDateCondition(exams, rq1[Keyword.ScheduledProcedureStepStartDate]);
                                    }
                                }

                                // Optional (but commonly used) matching keys.
                                if (rq1[Keyword.ScheduledProcedureStepLocation].ExistsWithValue)
                                    exams = exams.Where(x => x.ExamRoom.Equals(rq1[Keyword.ScheduledProcedureStepLocation].Value.ToString()));

                                if (rq1[Keyword.ScheduledProcedureStepDescription].ExistsWithValue)
                                    exams = exams.Where(x => x.ExamDescription.Equals(rq1[Keyword.ScheduledProcedureStepDescription].Value.ToString()));
                            }
                            results = exams.ToList();
                        }
                        else
                        {
                            //  Using SQL

                            // the "where 1=1" makes the syntax of adding further conditions simpler, as all are then " AND x=y"
                            string sql = SelectAllExamsScheduledWithWhere;
                            Utils_SQL.AddCondition(ref sql, rq[Keyword.PatientID], PatientId);
                            Utils_SQL.AddNameCondition(ref sql, rq[Keyword.PatientName], Surname, Forname);

                            if (rq[Keyword.ScheduledProcedureStepSequence].ExistsWithValue)
                            {
                                DicomDataSetCollection rqs;

                                rqs = (DicomDataSetCollection)rq[Keyword.ScheduledProcedureStepSequence].Value;
                                rq1 = rqs[0];

                                // Required Matching keys
                                Utils_SQL.AddCondition(ref sql, rq1[Keyword.ScheduledStationAETitle], ScheduledAET);
                                Utils_SQL.AddCondition(ref sql, rq1[Keyword.PerformingPhysicianName], PerformingPhysician);
                                Utils_SQL.AddCondition(ref sql, rq1[Keyword.Modality], Modality);

                                // if only date is specified, then using standard matching
                                //but if both are specified, then MWL defines a combined match

                                if (!DisableDateMatching.Checked)
                                {
                                    if (rq1[Keyword.ScheduledProcedureStepStartDate].ExistsWithValue && rq1[Keyword.ScheduledProcedureStepStartTime].ExistsWithValue) // if both Date and Time are specified
                                    {
                                        Utils_SQL.AddDateTimeCondition(ref sql, rq1[Keyword.ScheduledProcedureStepStartDate], rq1[Keyword.ScheduledProcedureStepStartTime], "ExamDateAndTime");
                                    }
                                    else if (rq1[Keyword.ScheduledProcedureStepStartDate].ExistsWithValue) // if Date is specified
                                    {
                                        Utils_SQL.AddDateCondition(ref sql, rq1[Keyword.ScheduledProcedureStepStartDate], ExamDateAndTime);
                                    }
                                }

                                // Optional (but commonly used) matching keys.
                                Utils_SQL.AddCondition(ref sql, rq1[Keyword.ScheduledProcedureStepLocation], ExamRoom);
                                Utils_SQL.AddCondition(ref sql, rq1[Keyword.ScheduledProcedureStepDescription], ExamDescription);
                            }

                            sql += OrderBy;
                            Log(QueryStatement + Environment.NewLine + sql);

                            //DataContext database = Utils.SetupDB();
                            results = DBContext.ExecuteQuery<ExamsScheduled>(sql);
                        }

                        //  Parsing result 
                        DicomDataSet rr1;
                        DicomDataSet rr;
                        DicomDataSetCollection rrs;
                        foreach (ExamsScheduled result in results)
                        {
                            rr1 = new DicomDataSet();
                            rr = new DicomDataSet();
                            rrs = new DicomDataSetCollection { rr1 };

                            if (rq1 != null)
                            {
                                rr.Add(Keyword.ScheduledProcedureStepSequence, rrs);
                            }

                            // add results to  "main" dataset

                            AddResultItem(rr, rq, Keyword.AccessionNumber, result.AccessionNumber);    // T2
                            AddResultItem(rr, rq, Keyword.InstitutionName, result.HospitalName);
                            AddResultItem(rr, rq, Keyword.ReferringPhysicianName, result.ReferringPhysician); // T2

                            AddResultItem(rr, rq, Keyword.PatientName, result.Surname + "^" + result.Forename + "^^" + result.Title); //T1
                            AddResultItem(rr, rq, Keyword.PatientID, result.PatientID); // T1
                            AddResultItem(rr, rq, Keyword.PatientBirthDate, result.DateOfBirth); // T2
                            AddResultItem(rr, rq, Keyword.PatientSex, result.Sex); //T2

                            AddResultItem(rr, rq, Keyword.StudyInstanceUID, result.StudyUID); // T1

                            AddResultItem(rr, rq, Keyword.RequestingPhysician, result.ReferringPhysician); //T2
                            AddResultItem(rr, rq, Keyword.RequestedProcedureDescription, result.ExamDescription); //T1C

                            AddResultItem(rr, rq, Keyword.RequestedProcedureID, result.ProcedureID); // T1

                            // Scheduled Procedure Step sequence T1
                            // add results to procedure step dataset
                            // Return if requested
                            if (rq1 != null)
                            {
                                AddResultItem(rr1, rq1, Keyword.ScheduledStationAETitle, result.ScheduledAET); // T1
                                AddResultItem(rr1, rq1, Keyword.ScheduledProcedureStepStartDate, result.ExamDateAndTime); //T1
                                AddResultItem(rr1, rq1, Keyword.ScheduledProcedureStepStartTime, result.ExamDateAndTime); //T1
                                AddResultItem(rr1, rq1, Keyword.Modality, result.Modality); // T1

                                AddResultItem(rr1, rq1, Keyword.ScheduledPerformingPhysicianName, result.PerformingPhysician); //T2
                                AddResultItem(rr1, rq1, Keyword.ScheduledProcedureStepDescription, result.ExamDescription); // T1C
                                AddResultItem(rr1, rq1, Keyword.ScheduledProcedureStepID, result.ProcedureStepID); // T1
                                AddResultItem(rr1, rq1, Keyword.ScheduledStationName, result.ExamRoom); //T2
                                AddResultItem(rr1, rq1, Keyword.ScheduledProcedureStepLocation, result.ExamRoom); //T2
                            }

                            // Put blanks in for unsupported fields which are type 2 (i.e. must have a value even if NULL)
                            // In a real server, you may wish to support some or all of these, but they are not commonly supported

                            AddResultItem(rr, rq, Keyword.ReferencedStudySequence, NullSequence);
                            AddResultItem(rr, rq, Keyword.Priority, "");
                            AddResultItem(rr, rq, Keyword.PatientTransportArrangements, "");
                            AddResultItem(rr, rq, Keyword.AdmissionID, "");
                            AddResultItem(rr, rq, Keyword.CurrentPatientLocation, "");
                            AddResultItem(rr, rq, Keyword.ReferencedPatientSequence, NullSequence);
                            AddResultItem(rr, rq, Keyword.PatientWeight, "");
                            AddResultItem(rr, rq, Keyword.ConfidentialityConstraintOnPatientDataDescription, "");
                            Log(SendingResponse);
                            // Send Reponse Back
                            e.SendResponse(rr, StatusCodes.Pending);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log(ErrorExecutingDatabase + ex.Message);
                status = StatusCodes.GeneralError; // Error, unable to process!
            }
            finally
            {
                Log(DatabaseDisconnected);
            }
            e.Status = status;
        }

        #endregion
        internal static void AddResultItem(DicomDataSet DataSet, DicomDataSet request, Keyword keyword, object v)
        {
            // Only send items which have been requested
            if (request[keyword].Exists)
            {
                if (v == null)
                    v = "";
                DataSet.Add(keyword, v);
            }
        }
        #region "Shutdown"
        private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            MWL_Server.UnlistenAll();
        }
        #endregion

    }
}

